using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using Android.App;
using Android.Content;
using Android.OS;
using Android.Runtime;
using Android.Views;
using Android.Widget;


namespace TestCustomObjectInArrayAdapter
{
    public class DeviceNameArrayAdapter : ArrayAdapter<String>
    {
        private int mResID;

        public DeviceNameArrayAdapter(Context c, int resID, string[] devices)
            : base(c, resID, devices)
        {
            mResID = resID;
        }

        public override View GetView(int position, View convertView, ViewGroup parent)
        {
            RelativeLayout layout;
            String deviceName = GetItem(position);

            if (convertView == null)
            {
                layout = new RelativeLayout(Context);
                String inflater = Context.LayoutInflaterService;
                LayoutInflater vi = (LayoutInflater)Context.GetSystemService(inflater);
                vi.Inflate(mResID, layout, true);
            }
            else
            {
                layout = (RelativeLayout)convertView;
            }

            // Set the text to use the DeviceName
            ((TextView)layout.FindViewById(Resource.Id.ImageText_Text)).Text = deviceName;

            // Set the image
            ImageView imgv = (ImageView)layout.FindViewById(Resource.Id.ImageText_Image);

            // set the drawable of the image view to the appropriate image
            // TOOD: have a different image for each OS type
            imgv.SetImageDrawable(Context.Resources.GetDrawable(Resource.Drawable.Icon));
            return layout;
        }
    }

    public class DeviceArrayAdapter : ArrayAdapter<Device>
    {
        private int mResID;

        public DeviceArrayAdapter(Context c, int resID, Device[] devices)
            : base(c, resID, devices)
        {
            mResID = resID;
        }

        public override View GetView(int position, View convertView, ViewGroup parent)
        {
            RelativeLayout layout;
            Device device = GetItem(position);

            if (convertView == null)
            {
                layout = new RelativeLayout(Context);
                String inflater = Context.LayoutInflaterService;
                LayoutInflater vi = (LayoutInflater)Context.GetSystemService(inflater);
                vi.Inflate(mResID, layout, true);
            }
            else
            {
                layout = (RelativeLayout)convertView;
            }

            // Set the text to use the DeviceName
            ((TextView)layout.FindViewById(Resource.Id.ImageText_Text)).Text = device.DeviceName;

            // Set the image
            ImageView imgv = (ImageView)layout.FindViewById(Resource.Id.ImageText_Image);

            // set the drawable of the image view to the appropriate image
            // TOOD: have a different image for each OS type
            imgv.SetImageDrawable(Context.Resources.GetDrawable(Resource.Drawable.Icon));
            return layout;
        }
    }
}